/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#ifndef __mynahsa_type_traits_hpp
#define __mynahsa_type_traits_hpp

#ifdef MYNAHSA_USE_BOOST

#include <boost/type_traits.hpp>
namespace MynahSA { 
  typedef boost::false_type false_t;
  typedef boost::true_type true_t;
  template<typename T>
  struct enum_t : public boost::is_enum<T> { } ;
  
  template<typename T>
  struct void_t : public boost::is_void<T> { };
  
  template<typename T>
  struct integer_t : public boost::is_integral<T> { };
  
  template<typename T>
  struct numeric_t : public boost::is_arithmetic<T> { };
  
  template<typename T>
  struct array_t : public boost::is_array<T> { };
  
  template<typename T>
  struct pointer_t : public boost::is_pointer<T> { };
  
  template<typename T>
  struct reference_t : public boost::is_reference<T> { };
  
  template<typename T>
  struct member_p_t : public boost::is_member_pointer<T> { };
  
  template<typename T>
  struct function_t : public boost::is_function<T> { };
  
  template<typename T>
  struct class_struct_union_t {
    typedef bool value_type;
    // see note regarding compiler compatibility of compilers in boost documentation.
    static const value_type value = boost::is_class<T>::value || boost::is_union<T>::value;
  };
  
  template<typename T>
  struct fundamental_t : public boost::is_fundamental<T> { };
  
};

#else


// This file contains a parital re-implementation of some of the functionality found in
// std::tr1 and boost::type_traits.  This code was written to remove the dependancy on a third party
// tr1 implementation.  It is sufficient only to provide is_enum<t>, the one function that MynahSA 
// depends on for archiving without major compiler problems.

namespace MynahSA { 

// Basic constant type
  template<typename t, t val>
  struct constant_t { 
    typedef t value_type;
    static const value_type value = val;
  };
  
// Specialization macro, creates a constant with specific value
#define SPECIALIZE_IT(newname, type, value) \
  typedef constant_t<type, value> newname;
  
// true type
SPECIALIZE_IT(true_t, bool, true);
// false type
SPECIALIZE_IT(false_t, bool, false);

// Definition of a trait
#define TRAITDEF( traitname ) \
template<typename t> \
struct traitname : public false_t { }
  
// assignment of truths to the trait - e.g. to make a char_t true for type char: TRAITTRUTH( char_t, char);
#define TRAITTRUTH( traitname, type ) \
  template<> struct traitname< type > : public true_t { };    \
  template<> struct traitname< const type > : public true_t {};   \
  template<> struct traitname< volatile type > : public true_t {};  \
  template<> struct traitname< const volatile type > : public true_t { }
  
  // integer types - all of these are different precision integers
  TRAITDEF( integer_t );
  TRAITTRUTH( integer_t, char );
  TRAITTRUTH( integer_t, unsigned char );
  TRAITTRUTH( integer_t, short );
  TRAITTRUTH( integer_t, unsigned short );
  TRAITTRUTH( integer_t, int );
  TRAITTRUTH( integer_t, unsigned int );
  TRAITTRUTH( integer_t, long );
  TRAITTRUTH( integer_t, unsigned long );
  TRAITTRUTH( integer_t, long long );
  TRAITTRUTH( integer_t, unsigned long long );
  
  // floating point types - note: solaris uses floating_t
  TRAITDEF( floating_t );
  TRAITTRUTH( floating_t, float);
  TRAITTRUTH( floating_t, double);
  TRAITTRUTH( floating_t, long double);
  
  // numeric trait - floats and integers
  template<typename t>
  struct numeric_t : public constant_t<bool, (integer_t<t>::value || 
                                              floating_t<t>::value) > { };
  // void trait
  TRAITDEF( void_t );
  TRAITTRUTH( void_t, void);
  
  // fundamental - all those builtin types in C/C++, numeric types and void
  template<typename t>
  struct fundamental_t : public constant_t<bool, (numeric_t<t>::value || 
                                                  void_t<t>::value) > { };
  
  
  // Array type - any size qualified array, and/or [] qualified type
  template<typename t>
  struct array_t : public false_t { };
  template<typename T, int Size>
  struct array_t<T [ Size ] > : public true_t { };
  template<typename T>
  struct array_t<T[]> : public true_t { };
  
  // Pointer types, anything with a * after it, including CV types
  template<typename t>
  struct pointer_t : public false_t {};
  template<typename T>
  struct pointer_t<T*> : public true_t { };
  
  
  // Reference types anything with an & after it, including CV types
  template<typename T>
  struct reference_t : public false_t {};
  template<typename T>
  struct reference_t<T&> : public true_t{};
  
  // member pointer type detector, default false case
  template<typename>
  struct member_p_t : public false_t { };
  
  // member pointer type detector, default true case
  template<typename X, typename Y>
  struct member_p_t<Y X::*> : public true_t { };
  
  template<typename A, typename T, typename P0>
  struct member_p_t<A (T::* )(P0)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1>
  struct member_p_t<A (T::* )(P0,P1)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2>
  struct member_p_t<A (T::* )(P0,P1,P2)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3>
  struct member_p_t<A (T::* )(P0,P1,P2,P3)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17, typename P18>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17, typename P18, typename P19>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17, typename P18, typename P19, typename P20>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17, typename P18, typename P19, typename P20, typename P21>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17, typename P18, typename P19, typename P20, typename P21, typename P22>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22)> : public true_t { };
  template<typename A, typename T, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5, typename P6, typename P7, typename P8, typename P9, typename P10, typename P11, typename P12, typename P13, typename P14, typename P15, typename P16, typename P17, typename P18, typename P19, typename P20, typename P21, typename P22, typename P23>
  struct member_p_t<A (T::* )(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P13,P14,P15,P16,P17,P18,P19,P20,P21,P22,P23)> : public true_t { };


 

  template< typename K >
  static char __test_class_struct_union_helper( int K::* );
  
  template< typename >
  static int __test_class_struct_union_helper( ... );


  // class, struct or union trait - this operates by creating a member pointer for the given 
  // type.  If the compiler CAN instantiate a member pointer, then the type is class, struct
  // or union type.  If not, its is not a class or union.
  // Note: this test will fail on machines where char and int occupy the same size in memory.
  template<typename T>
  struct class_struct_union_t {
    typedef bool value_type;
    // create a member pointer and try - 
    static const value_type value = (sizeof(__test_class_struct_union_helper<T>(0)) == sizeof(char));
  };
    

  // for reasons unknown to me, G++ < 4.0.2 doesn't deal with these 
  // in the private namespace.
  // SUNPro on the other hand, must have these in the struct definition.
#ifndef __SUNPRO_CC
  template<typename K>
  static char __test_array_helper( K(*)[1] );
  
  template<typename>
  static int __test_array_helper( ... );
#endif


  // in array trait - can the element be stored in an array.  Things that cannot
  // be stored in arrays are function types and references
  // Note: This test will fail on machines where char and int occupy the same number of bytes.
  template<typename T>
  struct in_array_t { 
#ifdef __SUNPRO_CC
    template<typename K>
    static char __test_array_helper( K(*)[1] );

    template<typename>
    static int __test_array_helper( ... );
#endif


    typedef bool value_type;
    static const value_type value = (sizeof(__test_array_helper<T>(0)) == sizeof(char));
  };
  
 
  // Function types - pointers to functions.  Those things that can sit in arrays, 
  // are not class, struct or unions, are not references 

  template<typename T>
  struct function_t {
    typedef bool value_type;
    static const value_type value = !(in_array_t<T>::value || 
				      class_struct_union_t<T>::value ||
				      reference_t<T>::value ||
				      void_t<T>::value );
  };

  /*
  template<typename T>
  struct xfunction_t : public constant_t<bool, !(class_struct_union_t<T>::value ||
                                                reference_t<T>::value ||
                                                void_t<T>::value ) > { };

  */

  template<typename T>
  struct enum_t : public constant_t<bool, !(fundamental_t<T>::value ||
                                            array_t<T>::value ||
                                            pointer_t<T>::value ||
                                            reference_t<T>::value ||
                                            member_p_t<T>::value ||
					    function_t<T>::value ||
                                            class_struct_union_t<T>::value ) > { };














}; // end namespace MynahSA


#endif

#endif
