/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/clientexception.hpp>

namespace MynahSA {

  ClientException::ClientException(ClientException::ErrorCode code) throw() : _ec(code) { 
  }
  
  ClientException::~ClientException() throw() { 
  }

  const char* ClientException::what() const throw() {
    switch (_ec) { 
    case CLIENT_ERROR_BIND:
      return "Bind error";
    case CLIENT_ERROR_CONNECT:
      return "Connect error";
    case CLIENT_ERROR_CREATE_SOCKET:
      return "Socket creation error";
    case CLIENT_ERROR_SOCKET_REUSE:
      return "Socket error in configuring socket for reuse";
    case SSLRPCCLIENT_ERROR_SSL_CONTEXT_CREATION:
      return "SSL Context creation error";
    case SSLRPCCLIENT_ERROR_SSL_NEW:
      return "SSL New failed";
    case SSLRPCCLIENT_ERROR_SSL_CONNECT:
      return "SSL Connect failed";
    case CLIENT_ERROR_WRITE:
      return "SSL Write failed";
    case CLIENT_ERROR_READ:
      return "SSL Read failed";
    case SSLRPCCLIENT_ERROR_LOAD_CERT:
      return "Failed to load certificate file";
    case SSLRPCCLIENT_ERROR_LOAD_PKEY:
      return "Failed to load private key file";
    case SSLRPCCLIENT_PKEY_INVALID:
      return "Private key is invalid for specified certificate";
    case CLIENT_NO_ADDRESS:
      return "No address associated with name";
    case CLIENT_ADDRESS_CONVERSION_ERROR:
      return "Failed to convert machine address into native byte format";
    default:
      return "Unknown";
    }
  }
};
