/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/ibinarystream.hpp>

#if BYTE_ORDER == BIG_ENDIAN
#include <mynahsa/byteswap.hpp>
#endif

using namespace std;
namespace MynahSA {
  IBinaryStream::IBinaryStream(istream& is) : _is(is) { 
  }
  
  IBinaryStream::IBinaryStream(const IBinaryStream& is) : _is(is._is) { 
  }
  
  
  IBinaryStream::~IBinaryStream() {
  }
  
#if BYTE_ORDER == LITTLE_ENDIAN
#define MAKE_LOADER( type ) \
IStreamBase& IBinaryStream::operator>>( type & c ) { \
  char* cp = reinterpret_cast<char*>(&c); \
  for (unsigned int i = 0; i< sizeof(type); i++) { \
    _is.get(cp[i]); \
  } \
  return *this; \
}
#else
#define MAKE_LOADER( type ) \
IStreamBase& IBinaryStream::operator>>( type & c ) { \
  char* cp = reinterpret_cast<char*>(&c); \
  for (unsigned int i = 0; i< sizeof(type); i++) { \
    _is.get(cp[i]); \
  } \
  byteswap(c); \
  return *this; \
}
#endif
  
  MAKE_LOADER( char );
  MAKE_LOADER( unsigned char );
  MAKE_LOADER( short );
  MAKE_LOADER( unsigned short );
  MAKE_LOADER( int );
  MAKE_LOADER( unsigned int );
  MAKE_LOADER( long long );
  MAKE_LOADER( unsigned long long );
  MAKE_LOADER( float );
  MAKE_LOADER( double );
#undef MAKE_LOADER
  // this is a code workaround for architectures that use 4 byte bool specifications.  This clamps it onto a 1 
  // byte specification which is like x86_64.  After all there is no need to spend more that 1 bit on a bool anyway!
  IStreamBase& IBinaryStream::operator>>(bool & b ) { 
    char c;
    (*this) >> c;
    b = c;
    return *this;
  }
  
  
  void IBinaryStream::get(char& c) { 
    _is.get(c);
  }

};


