/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/itextstream.hpp>

using namespace std;

namespace MynahSA { 

  ITextStream::ITextStream(istream& i) : _is(i) {
  }
  
  ITextStream::ITextStream(const ITextStream& is) : _is(is._is) { 
  }
  
  ITextStream::~ITextStream() {
  }
  
  IStreamBase& ITextStream::operator>>(unsigned char& c) { 
    unsigned int i;
    _is >> i;
    c = ((unsigned char) i);
    return *this;
  }
  
  IStreamBase& ITextStream::operator>>(char& c) { 
    int i;
    _is >> i;
    c = ((int) i);
    return *this;
  }
  
// none of these methods are special; we just duplicate the std::istream input methods
#define MAKE_LOADER( x ) IStreamBase& ITextStream::operator>>(x & s ) { \
  _is >> s; \
  return *this; \
}
  
  MAKE_LOADER( short );
  MAKE_LOADER( unsigned short );
  MAKE_LOADER( bool );
  MAKE_LOADER( int );
  MAKE_LOADER( unsigned int );
  MAKE_LOADER( long long );
  MAKE_LOADER( unsigned long long );
  MAKE_LOADER( double );
  MAKE_LOADER( float );
  
#undef MAKE_LOADER
    
  IStreamBase& ITextStream::operator>>(string& s) { 
    int nChars;
    (*this) >> nChars;
    char c;
    get(c); // skip white space
    for (unsigned int i=0; i<nChars; i++) { 
      get(c);
      s += c;
    }
    return *this;
  }
  
  
  void ITextStream::get(char& c) {
    _is.get(c);
  }
};
