/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/ostreambase.hpp>
#include <iostream>
using namespace std;

namespace MynahSA { 

  OStreamWriteError::OStreamWriteError(const std::string& c) : ExceptionBase(c) {
  };
  
  OStreamWriteError::~OStreamWriteError() throw() {
  }

  OStreamBase::OStreamBase() { 
  }
  
  OStreamBase::~OStreamBase() { 
    // destructor does nothing
  }
  
  OStreamBase& OStreamBase::operator<<(const string& s) {
    // protocol format - store the string size first, then the string characters.
    (*this) << ((unsigned int) s.size()); // stream the size
    for (unsigned int i=0; i<s.size(); i++) { 
      (*this) << (s[i]);
    }
    return *this;
  }
};
