/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/otextstream.hpp>

using namespace std;

namespace MynahSA { 

  OTextStream::OTextStream(ostream& o) : _os(o) {
  }
  
  OTextStream::OTextStream(const OTextStream& os) : _os(os._os) { 
  }
  
  OTextStream::~OTextStream() { 
  }
  
  
  OStreamBase& OTextStream::operator<<(unsigned char c) { 
    _os << ((unsigned int) (c)) << " ";
    return *this;
  }
  
  OStreamBase& OTextStream::operator<<(const char c) { 
    _os << ((unsigned int) (c)) << " ";
    return *this;
  }
  
#define MAKE_SAVER( x ) OStreamBase& OTextStream::operator<<(x s) { \
  _os << s << " ";\
  return *this;\
}\
  
  MAKE_SAVER( short );
  MAKE_SAVER( unsigned short );
  MAKE_SAVER( const int );
  MAKE_SAVER( const unsigned int );
  MAKE_SAVER( const bool );
  MAKE_SAVER( const long long );
  MAKE_SAVER( const unsigned long long );
  MAKE_SAVER( const double );
  MAKE_SAVER( const float );
  
#undef MAKE_SAVER
  
  OStreamBase& OTextStream::operator<<(const string& c) { 
    // output stream foramt for string is inverse of forward stream:
    //  first store the size of the string, then a space, then the string
    _os << c.size() << " " << c;
    return *this;
  };
};
