/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/sainit.hpp>

#include <mynahsa/sslinit.hpp>

#ifdef WIN32
#include <windows.h>
#include <winsock2.h>
#endif

namespace MynahSA { 

  int saInit(bool initTCP, bool initSSL) { 
    int result = 0;
    
    if (initTCP) { 
  
#ifdef WIN32
      WORD wVersionRequested;
      WSADATA wsaData;
      int err;
      
      wVersionRequested = MAKEWORD( 2, 2 );
      
      err = WSAStartup( wVersionRequested, &wsaData );
      if ( err != 0 ) {
        /* Tell the user that we could not find a usable */
        /* WinSock DLL.                                  */
        result = 1;
      }
#endif
    }
  
    if (initSSL) { 
      sslInit();
    }
  
    return result;
  
  }
};
