/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/sslarchivestream.hpp>

namespace MynahSA { 

  SSLArchiveStream::SSLArchiveStream(SSL* s) : _ssl(s),
                is(s),
                os(s),
                                              ISSLArchiveStream(is),
                                              OSSLArchiveStream(os) {
  }
  
  SSLArchiveStream::SSLArchiveStream(const SSLArchiveStream& s) : _ssl(s._ssl),
                  is(s._ssl),
                  os(s._ssl),
                  ISSLArchiveStream(is),
                  OSSLArchiveStream(os) {
  }
  
  SSLArchiveStream::~SSLArchiveStream() { 
  }
  
  bool SSLArchiveStream::is_open() const { 
    return (SSL_get_shutdown(_ssl) == 0);
  }
  
  void SSLArchiveStream::close() { 
    SSL_shutdown(_ssl);
  }
  
  void SSLArchiveStream::registerConstructor(const std::string& name, 
                                             const SHARED_PTR<Archive::ArchiveConstructor>& cons) { 
                                             
    ISSLArchiveStream::registerConstructor(name, cons);
                                             
  }              
  
  void SSLArchiveStream::clearUPR() {
    ISSLArchiveStream::clearUPR();
    OSSLArchiveStream::clearUPR();
  }                               
  
  
};



