/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/tcparchivestream.hpp>

#ifndef WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/socket.h>
#include "errno.h"
#else
#include <windows.h>
#include <winsock2.h>
#endif

namespace MynahSA { 
  TCPArchiveStream::TCPArchiveStream(int s) : _sd(s),
                                              is(s),
                                              os(s),
                                              ITCPArchiveStream(is),
                                              OTCPArchiveStream(os) {
  }
  
  TCPArchiveStream::TCPArchiveStream(const TCPArchiveStream& s) : _sd(s._sd),
                                                                  is(s._sd),
                                                                  os(s._sd),
                                                                  ITCPArchiveStream(is),
                                                                  OTCPArchiveStream(os) {
  }
  
  TCPArchiveStream::~TCPArchiveStream() { 
  }
  
  bool TCPArchiveStream::is_open() const {   
#ifndef WIN32
    socklen_t zero = 0;
#else
    int zero = 0;
#endif
    int result = getsockopt(_sd, SOL_SOCKET,  SO_REUSEADDR ,0,&zero);
  
#ifndef WIN32
    if (result == EBADF || result == ENOTSOCK) { 
      return false;
    }
#else
    if (result == WSAENOTSOCK) { 
      return false;
    }
#endif
    return true;
  }
  
  void TCPArchiveStream::close() { 
#ifndef WIN32
    ::close(_sd);
#else
    closesocket(_sd);
#endif
  }
  
  
  void TCPArchiveStream::registerConstructor(const std::string& name, 
                                             const SHARED_PTR<Archive::ArchiveConstructor>& cons) { 
                                          
    ITCPArchiveStream::registerConstructor(name, cons);
                                             
  }          
      
      
  void TCPArchiveStream::clearUPR() {
    ITCPArchiveStream::clearUPR();
    OTCPArchiveStream::clearUPR();
  }

  
  
};
