/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <mynahsa/thread.hpp>

#include <iostream>
using namespace std;

#ifndef MYNAHSA_USE_BOOST

namespace MynahSA { 

  Mutex::Mutex() { 
#ifdef WIN32
    _mutex = CreateMutex(0,FALSE,0);
#else
    pthread_mutex_init(&_mutex, 0);
#endif
  }
  
  Mutex::~Mutex() { 
#ifdef WIN32
    CloseHandle(_mutex);
#else
    pthread_mutex_destroy(&_mutex);
#endif
  }

  Lock::Lock(Mutex& m) : _mutex(m) { 
    Mutex::lock(_mutex);
  }
  
  
  Lock::~Lock() { 
    Mutex::unlock(_mutex);
  }

};

#endif