/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <iostream>
#include <fstream>
#include <stdexcept>

#include <mynahsa/oarchive.hpp>
#include <mynahsa/ostreambase.hpp>
#include <mynahsa/obinarystream.hpp>

#include <mynahsa/iarchive.hpp>
#include <mynahsa/ibinarystream.hpp>


#include "testcontainer.hpp"

using namespace std;
using namespace MynahSA;

int main() { 
  try { 

    ifstream ifs("test.dat");
    if (!ifs.is_open()) { 
      throw logic_error("Error in opening test.dat: Did you run savetest first?");
    }
    
    cout << "Loading test data from test.dat...";
    
    IBinaryStream ibs(ifs);
    IArchive<IBinaryStream> iabs(ibs);
    
    TestContainer tc;
    tc.populateTestData();
    
    TestContainer tc2;
    iabs >> tc2;
    
    cout << "done" << endl;
    
    if (tc == tc2) { 
      cerr << "Test passed" << endl;
    } else { 
      cerr << "Test failed: " << endl;
      tc.testCompare(tc2);
    }
  } catch (logic_error& le) { 
    cerr << le.what() << endl;
    return 1;
  } catch (...) { 
    cerr << "Unknown exception trapped; check and debug!" << endl;
    return 1;
  }
  return 0;
};