/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include <iostream>
#include <fstream>

#include <mynahsa/oarchive.hpp>
#include <mynahsa/ostreambase.hpp>
#include <mynahsa/obinarystream.hpp>

#include <mynahsa/iarchive.hpp>
#include <mynahsa/ibinarystream.hpp>


#include "testcontainer.hpp"

using namespace std;
using namespace MynahSA;

int main() { 
  cerr << "Writing test data to test.dat...";
  ofstream ofs("test.dat");
  OBinaryStream obs(ofs);
  OArchive<OBinaryStream> oabs(obs);
  
  TestContainer tc;
  tc.populateTestData();
  oabs << tc;
  cerr << " done" << endl;
}
