/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "tcptestserverthread.hpp"

#include "testcontainerstreamconstructor.hpp"
#include "testcontainerrequestresponsehandler.hpp"

#include <mynahsa/tcprpcserver.hpp>

#include <mynahsa/spimpl.hpp>


#include <iostream>

using namespace std;
using namespace MynahSA;

//! note: this must be a reference - the references will be shared between threads, a copied variable will not
TCPTestServerThread::TCPTestServerThread(const bool& running) : _running(running) {
}

TCPTestServerThread::~TCPTestServerThread() { 
}

void TCPTestServerThread::operator()() { 
  // start the thread
  try {   
    TestContainerRequestResponseHandler myHandler;
    TestContainerStreamConstructor myConstructor;
    TCPConnectionManager cm(myHandler,
                         myConstructor);
    TCPRPCServer server(cm, 7501);
    while (_running) { 
      try { 
        server.checkClients(1);
      } catch (...) { 
        cerr << "Unexpected exception!" << endl;
      }
    }
  } catch (...) { 
    cerr << "SERVER CAUGHT A FATAL EXCEPTION!" << endl;
  }
}
