/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/

#include "testserverthread.hpp"

#include "testcontainerstreamconstructor.hpp"
#include "testcontainerrequestresponsehandler.hpp"

#include <mynahsa/sslrpcserver.hpp>

#include <mynahsa/mkcert.hpp>

#include <mynahsa/sslconnectionverifier.hpp>

#include <mynahsa/spimpl.hpp>


#include <iostream>

using namespace std;
using namespace MynahSA;


//! note: this must be a reference - the references will be shared between threads, a copied variable will not
TestServerThread::TestServerThread(const bool& running) : _running(running) {
}

TestServerThread::~TestServerThread() { 
}

void TestServerThread::operator()() { 
  // start the thread
  
  X509* cert = 0;
  EVP_PKEY* pkey = 0;
  
  TestContainerRequestResponseHandler myHandler;
  TestContainerStreamConstructor myConstructor;
  SSLConnectionVerifier myVerifier;
  SSLConnectionManager cm(myHandler,
                          myConstructor,
                          myVerifier);
  mkcert(&cert, &pkey, 1024, 0, 760);
  SSLRPCServer server(cm, cert, pkey, 7501);
  
  while (_running) { 
    try { 
      server.checkClients(1);
    } catch (...) { 
      cerr << "Unexpected exception!" << endl;
    }
  }
  EVP_PKEY_free(pkey);
  X509_free(cert);
}
