/************************************************************************************
 *    This file is part of the MynahSA streaming and archiving toolkit              *
 *    Copyright (C) 2006 Mynah-Software Ltd. All Rights Reserved.                   *
 *                                                                                  *
 *    This program is free software; you can redistribute it and/or modify          *
 *    it under the terms of the GNU General Public License, version 2               *
 *    as published by the Free Software Foundation.                                 *
 *                                                                                  *
 *    This program is distributed in the hope that it will be useful,               *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 *    GNU General Public License for more details.                                  *
 *                                                                                  *
 *    You should have received a copy of the GNU General Public License along       *
 *    with this program; if not, write to the Free Software Foundation, Inc.,       *
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                   *
 *                                                                                  *
 ************************************************************************************/


// test suite for type_traits.  Note - the builtin type_traits library is designed to perform enum_t only.
// several additional types are supported.  This type traits library should not be regarded as a complete solution.
// you are encouraged to look at boost::type_traits and/or your compiler's tr1 implementation.  Gcc 4+ support tr1, and
// Visual Studio 2005 with clr support has type traits functions embedded.

#include <mynahsa/type_traits.hpp>
#include <iostream>

using namespace MynahSA;
using namespace std;

class X { 
public:
  X() { 
  }
  ~X() {
  }
  int doSomething(char v) { 
    return 3;
  }
};

typedef int (X::* xcharptr)(char);
typedef char (X::* xspecial)(int, char, const float);
typedef int (X::* xintmember);

enum TestEnum { A, B };

typedef void(* voidfnt)();

bool testTrait(const char* traitName, bool traitValue, bool traitShouldBe) { 
  if (traitShouldBe != traitValue) { 
    cerr << "Error, trait: " << traitName << " should be: " << traitShouldBe << " but is: " << traitValue << endl;
    return false;
  } else { 
    return true;
  }
}

bool testTraits() { 
  return   
    testTrait("integer_t<const int>", integer_t<const int>::value, true) &&
    testTrait("integer_t<char>", integer_t<char>::value, true) &&
    testTrait("numeric_t<float>", numeric_t<float>::value, true) &&
    testTrait("numeric_t<void>", numeric_t<void>::value, false) &&  
    testTrait("array_t<int[5]>", array_t<int[5]>::value, true) &&
    testTrait("array_t<const int[]>", array_t<const int[]>::value, true)&&
    testTrait("array_t<const volatile float[]>", array_t<const volatile float[]>::value, true) &&
    testTrait("array_t<char*>", array_t<char*>::value, false) &&
    testTrait("pointer_t<char*>", pointer_t<char*>::value, true) &&
    testTrait("pointer_t< const char *>", pointer_t<const char*>::value, true)&&
    testTrait("pointer_t< const volatile char*>", pointer_t<const volatile char*>::value, true) &&
    testTrait("reference_t<char&>", reference_t<char&>::value, true) &&
    testTrait("reference_t<const char&>", reference_t<const char&>::value, true) && 
    testTrait("member_p_t<xcharptr>", member_p_t<xcharptr>::value, true) &&
    testTrait("member_p_t<xintmember>", member_p_t<xintmember>::value, true) &&
    testTrait("member_p_t<xspecial>", member_p_t<xspecial>::value, true) &&
    testTrait("member_p_t<char>", member_p_t<char>::value, false) &&
    testTrait("class_struct_union_t<char>", class_struct_union_t<char>::value, false)&&
    testTrait("class_struct_union_t<X>", class_struct_union_t<X>::value, true )&&
  

  
    testTrait("function_t<char>", function_t<char>::value, false) &&
  
    testTrait("enum_t<TestEnum>", enum_t<TestEnum>::value, true) &&
  
    testTrait("class_struct_union_t<false_t>", class_struct_union_t<false_t>::value, true) &&
    testTrait("function_t<voidfnt>", function_t<voidfnt>::value, false) &&   // is a function pointer
    testTrait("function_t<xcharptr>", function_t<xcharptr>::value, false) && // false, is a member function pointer
    testTrait("function_t< void (void) >::value", function_t< void (void) >::value, true) && // is a function
  
#ifndef MYNAHSA_USE_BOOST
    // this is not represented in boost.
    testTrait("in_array_t<char>", in_array_t<char>::value, true) &&
    testTrait("in_array_t<char&>", in_array_t<char&>::value, false) &&
    testTrait("in_array_t<long (double,int)>::value",  in_array_t<long (double,int)>::value, false) && // false functions not allowed in arrays
#endif
    testTrait("class_struct_union_t<long (double,int)>::value", class_struct_union_t<long (double,int)>::value, false) &&
    testTrait("reference_t<long (double,int)>::value", reference_t<long (double,int)>::value, false) &&
    testTrait("void_t<long (double,int)>::value", void_t<long (double,int)>::value, false);
}

int main() { 
  cout << "Testing traits ...";
  if (testTraits()) { 
    cout << "passed." << endl;
    return 0;
  } else { 
    cout << "FAILED!" << endl;
    return 1;
  }
}